<?php
/**
 * Plugin Name: wpForo Stealth Delay Pro (Multi-lang v1.0)
 * Description: Stealth protection with support for DA, EN, DE, FR, SV, NO, ES.
 * Version: 1.0
 * Author: Thailand Portalen (www.thailand-portalen.dk)
 */

if (!defined('ABSPATH')) exit;

// 1. Database-tabel oprettelse
register_activation_hook(__FILE__, 'wcr_create_table_v17');
function wcr_create_table_v17() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'wcr_delayed_ips';
    $charset_collate = $wpdb->get_charset_collate();
    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        ip_address varchar(45) NOT NULL,
        delay_hours int NOT NULL DEFAULT 24,
        PRIMARY KEY  (id),
        UNIQUE KEY ip_address (ip_address)
    ) $charset_collate;";
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}

// 2. Oversættelses-logik (Support for 7 sprog)
function wcr_translate($text) {
    $locale = get_locale();
    $lang = substr($locale, 0, 2); 

    $translations = [
        'da' => [
            'title' => 'wpForo Stealth Forsinkelse',
            'your_ip' => 'Din nuværende IP',
            'add_ip' => 'Tilføj IP til overvågning',
            'ip_addr' => 'IP Adresse',
            'hours' => 'Timer',
            'save' => 'Gem IP og skjul indhold',
            'ip_list' => 'Overvågede IP-adresser',
            'action' => 'Handling',
            'delete' => 'Fjern',
            'not_found' => 'Siden kunne ikke findes.',
            'not_avail' => 'Ikke tilgængelig endnu'
        ],
        'en' => [
            'title' => 'wpForo Stealth Delay',
            'your_ip' => 'Your current IP',
            'add_ip' => 'Add IP to monitoring',
            'ip_addr' => 'IP Address',
            'hours' => 'Hours',
            'save' => 'Save IP and hide content',
            'ip_list' => 'Monitored IP addresses',
            'action' => 'Action',
            'delete' => 'Remove',
            'not_found' => 'Page not found.',
            'not_avail' => 'Not available yet'
        ],
        'sv' => [
            'title' => 'wpForo Stealth Fördröjning',
            'your_ip' => 'Din nuvarande IP',
            'add_ip' => 'Lägg till IP för övervakning',
            'ip_addr' => 'IP-adress',
            'hours' => 'Timmar',
            'save' => 'Spara IP och dölj innehåll',
            'ip_list' => 'Övervakade IP-adresser',
            'action' => 'Åtgärd',
            'delete' => 'Ta bort',
            'not_found' => 'Sidan kunde inte hittas.',
            'not_avail' => 'Inte tillgänglig än'
        ],
        'nb' => [ // Norsk Bokmål
            'title' => 'wpForo Stealth Forsinkelse',
            'your_ip' => 'Din nåværende IP',
            'add_ip' => 'Legg til IP for overvåking',
            'ip_addr' => 'IP-adresse',
            'hours' => 'Timer',
            'save' => 'Lagre IP og skjul innhold',
            'ip_list' => 'Overvåkede IP-adresser',
            'action' => 'Handling',
            'delete' => 'Fjern',
            'not_found' => 'Siden ble ikke funnet.',
            'not_avail' => 'Ikke tilgjengelig ennå'
        ],
        'nn' => [ // Nynorsk (samme som bokmål i dette tilfælde)
            'title' => 'wpForo Stealth Forsinkelse',
            'your_ip' => 'Din noverande IP',
            'add_ip' => 'Legg til IP for overvaking',
            'ip_addr' => 'IP-adresse',
            'hours' => 'Timar',
            'save' => 'Lagra IP og skjul innhald',
            'ip_list' => 'Overvaka IP-adresser',
            'action' => 'Handling',
            'delete' => 'Fjern',
            'not_found' => 'Sida vart ikkje funnen.',
            'not_avail' => 'Ikkje tilgjengeleg enno'
        ],
        'es' => [
            'title' => 'wpForo Stealth Retraso',
            'your_ip' => 'Su IP actual',
            'add_ip' => 'Añadir IP para monitoreo',
            'ip_addr' => 'Dirección IP',
            'hours' => 'Horas',
            'save' => 'Guardar IP y ocultar contenido',
            'ip_list' => 'Direcciones IP monitoreadas',
            'action' => 'Acción',
            'delete' => 'Eliminar',
            'not_found' => 'Página no encontrada.',
            'not_avail' => 'Aún no disponible'
        ],
        'de' => [
            'title' => 'wpForo Stealth Verzögerung',
            'your_ip' => 'Ihre aktuelle IP',
            'add_ip' => 'IP zur Überwachung hinzufügen',
            'ip_addr' => 'IP-Adresse',
            'hours' => 'Stunden',
            'save' => 'IP speichern und Inhalt verbergen',
            'ip_list' => 'Überwachte IP-Adressen',
            'action' => 'Aktion',
            'delete' => 'Entfernen',
            'not_found' => 'Seite nicht gefunden.',
            'not_avail' => 'Noch nicht verfügbar'
        ],
        'fr' => [
            'title' => 'wpForo Stealth Retard',
            'your_ip' => 'Votre IP actuelle',
            'add_ip' => 'Ajouter une IP à surveiller',
            'ip_addr' => 'Adresse IP',
            'hours' => 'Heures',
            'save' => 'Enregistrer l\'IP et masquer le contenu',
            'ip_list' => 'Adresses IP surveillées',
            'action' => 'Action',
            'delete' => 'Supprimer',
            'not_found' => 'Page non trouvée.',
            'not_avail' => 'Pas encore disponible'
        ]
    ];

    $set = isset($translations[$lang]) ? $translations[$lang] : $translations['en'];
    return isset($set[$text]) ? $set[$text] : $text;
}

// 3. Admin Menu & Page
add_action('admin_menu', 'wcr_admin_menu_v17');
function wcr_admin_menu_v17() {
    add_menu_page(wcr_translate('title'), 'wpForo Delay', 'manage_options', 'wpforo-delay', 'wcr_admin_page_v17', 'dashicons-clock');
}

function wcr_get_ip_v17() {
    $ip = $_SERVER['REMOTE_ADDR'];
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ips = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        $ip = trim($ips[0]);
    } elseif (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        $ip = $_SERVER['HTTP_CF_CONNECTING_IP'];
    }
    return $ip;
}

function wcr_admin_page_v17() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'wcr_delayed_ips';
    if (isset($_GET['delete'])) $wpdb->delete($table_name, array('id' => intval($_GET['delete'])));
    if (isset($_POST['add_ip'])) {
        $wpdb->replace($table_name, array(
            'ip_address' => sanitize_text_field(trim($_POST['ip_address'])),
            'delay_hours' => intval($_POST['delay_hours'])
        ));
    }
    $results = $wpdb->get_results("SELECT * FROM $table_name");
    ?>
    <div class="wrap">
        <h1><?php echo wcr_translate('title'); ?></h1>
        <p><?php echo wcr_translate('your_ip'); ?>: <strong><?php echo wcr_get_ip_v17(); ?></strong></p>
        <form method="post" style="background:#fff; padding:15px; border:1px solid #ccd0d4; max-width:400px;">
            <h3><?php echo wcr_translate('add_ip'); ?></h3>
            <input type="text" name="ip_address" placeholder="<?php echo wcr_translate('ip_addr'); ?>" required style="width:100%; margin-bottom:10px;">
            <input type="number" name="delay_hours" placeholder="<?php echo wcr_translate('hours'); ?>" required style="width:100%; margin-bottom:10px;">
            <input type="submit" name="add_ip" class="button button-primary" value="<?php echo wcr_translate('save'); ?>">
        </form>
        <h2 style="margin-top:30px;"><?php echo wcr_translate('ip_list'); ?></h2>
        <table class="wp-list-table widefat fixed striped">
            <thead><tr><th><?php echo wcr_translate('ip_addr'); ?></th><th><?php echo wcr_translate('hours'); ?></th><th><?php echo wcr_translate('action'); ?></th></tr></thead>
            <tbody><?php foreach ($results as $row): ?>
                <tr><td><?php echo esc_html($row->ip_address); ?></td><td><?php echo esc_html($row->delay_hours); ?></td><td><a href="?page=wpforo-delay&delete=<?php echo $row->id; ?>"><?php echo wcr_translate('delete'); ?></a></td></tr>
            <?php endforeach; ?></tbody>
        </table>
    </div>
    <p>Made by: <a href="https://www.thailand-portalen.dk" target="_blank">Thailand Portalen</a> - For more information visit: <a href="https://wpforo.com/community/general-discussions/delay-in-wpforo-2/" target="_blank">wpForo</a></p>
    <?php
}

// 4. Logik for blokering, RSS, Forum-oversigt og Widgets (v1.5+ kerne)
add_action('init', 'wcr_block_logic_v17', 1);
function wcr_block_logic_v17() {
    if (is_admin()) return;
    global $wpdb;
    $user_ip = wcr_get_ip_v17();
    $target = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->prefix}wcr_delayed_ips WHERE ip_address = %s", $user_ip));
    if ($target) {
        $topic_id = 0;
        if (isset($_GET['wpf_tid'])) { $topic_id = intval($_GET['wpf_tid']); } 
        else {
            $path_parts = explode('/', trim($_SERVER['REQUEST_URI'], '/'));
            $slug = end($path_parts);
            if ($slug) $topic_id = $wpdb->get_var($wpdb->prepare("SELECT topicid FROM {$wpdb->prefix}wpforo_topics WHERE slug = %s", $slug));
        }
        if ($topic_id) {
            $topic = $wpdb->get_row($wpdb->prepare("SELECT created FROM {$wpdb->prefix}wpforo_topics WHERE topicid = %d", $topic_id));
            if ($topic && time() < (strtotime($topic->created) + ($target->delay_hours * 3600))) {
                status_header(404);
                nocache_headers();
                wp_die(wcr_translate('not_found'), "404 Not Found", array('response' => 404));
                exit;
            }
        }
    }
}

add_filter('wpforo_get_topics', 'wcr_hide_topics_v17');
function wcr_hide_topics_v17($topics) {
    if (is_admin() || empty($topics)) return $topics;
    global $wpdb;
    $target = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->prefix}wcr_delayed_ips WHERE ip_address = %s", wcr_get_ip_v17()));
    if ($target) {
        foreach ($topics as $key => $topic) {
            if (time() < (strtotime($topic['created']) + ($target->delay_hours * 3600))) unset($topics[$key]);
        }
    }
    return $topics;
}

add_action('pre_get_posts', 'wcr_rss_filter_v17');
function wcr_rss_filter_v17($query) {
    if ($query->is_feed && !is_admin()) {
        global $wpdb;
        $target = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->prefix}wcr_delayed_ips WHERE ip_address = %s", wcr_get_ip_v17()));
        if ($target) $query->set('date_query', [['before' => intval($target->delay_hours) . ' hours ago']]);
    }
}

add_action('dynamic_sidebar_before', function(){ ob_start('wcr_widget_cleaner_v17'); });
add_action('dynamic_sidebar_after', function(){ if (ob_get_length()) ob_end_flush(); });
function wcr_widget_cleaner_v17($output) {
    global $wpdb;
    $target = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->prefix}wcr_delayed_ips WHERE ip_address = %s", wcr_get_ip_v17()));
    if ($target && strpos($output, 'wpf-widget-recent-replies') !== false) {
        $output = preg_replace_callback('/<li[^>]*>.*?<\/li>/is', function($m) use ($target, $wpdb) {
            if (preg_match('/href=["\']([^"\']*)["\']/', $m[0], $url_m)) {
                $slug = basename(parse_url($url_m[1], PHP_URL_PATH));
                $topic = $wpdb->get_row($wpdb->prepare("SELECT created FROM {$wpdb->prefix}wpforo_topics WHERE slug = %s", $slug));
                if ($topic && time() < (strtotime($topic->created) + ($target->delay_hours * 3600))) return '';
            }
            return $m[0];
        }, $output);
    }
    return $output;
}
